/*
 * @(#)c_postmortem.h   1.9 04/09/16
 */

#ifndef _C_POSTMORTEM_H
#define _C_POSTMORTEM_H

#include "g_conf.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)

#define ISR_ACTIVATE            1
#define ISR_EVENT               2
#define ALR_ACTIVATE            3
#define ALR_EVENT               4
#define TASK_ACTIVATE           5
#define TASK_EVENT              6
#define CTX_SWITCH              7
#define WAIT_EVENT              8
#define RAISE_PRIORITY          9
#define LOWER_PRIORITY          10
#define TASK_TERMINATE          11


/************************************************ 
 * To avoid byte-order and/or alignment problems
 * when this code applies to different targets,
 * we explicitely define the layout of 
 * a 'playback' event byte by byte.
 * We sacrifice performance (copying involves
 * tedious shift operations) to gain
 * portability.
 ***********************************************/

/********************************************
 * Common layout (5 bytes):
 *  0  1   2   3  4
 *  Th Tmh Tml Tl RP
 *  An OSEK playback adds 6 bytes:
 *  5  6  7  8   9   10
 *  TY AC Ih Imh Iml Il
 *******************************************/
typedef struct pevent _os_PEVENT;
struct pevent
{
        uint8_t time[sizeof(uint32_t)];
        uint8_t runprio;
        uint8_t type;
        uint8_t actor;
        uint8_t info[sizeof(uint32_t)];
};
#if     (_os_OS_0_POSTMORTEM == _os_OS_REALTIME)
        /* implemented by user - real time interface - */
        extern void SendPlaybackEvent(uint8_t*,uint8_t);
        /* Interface for soft real time logging in the idle
         * task: it pops a new event from the non-empty
         * log buffer and uses 'SendPlaybackEvent'
         * to log it externally */ 
#       if ( _os_OS_0_HARDLOGGING==0 )
        extern uint_fast8_t _os_SoftRTEventLog(void);
#       endif
#endif

        extern void _os_LogPlaybackEvent(
                             uint8_t type,
                             uint8_t actor,
                             uint32_t info);
#endif


#endif /* _c_postmortem_h */



