/****************************************************************
**  FILE:       @(#)c_limits.h  1.4 04/11/12 
**  DESCRIPTION:                                                *
**      Included from toc-generated 'g_conf_types.h' to         *
**      perform some oil-related-checks at preprocessing time.  *
****************************************************************/
#ifndef _H_OS_C_LIMITS
#define _H_OS_C_LIMITS

#include <osek/osek.h>
#include "t_limits.h"

/* Check maximum number of OIL objects have not been exceeded */

/* EVENTS */
#define _os_MAX_NO_EVENT        32
#if (_os_NO_EVENT>_os_MAX_NO_EVENT)
#error  "OIL Error: Max number EVENTs exceeded"
#endif

/* TASKS */
#define _os_MAX_NO_TASK         INT_FAST8_MAX   
#if (_os_NO_TASK>_os_MAX_NO_TASK)
#error  "OIL Error: Max number TASKs exceeded"
#endif

/* COUNTERS */
#define _os_MAX_NO_COUNTER      INT_FAST8_MAX   
#if (_os_NO_COUNTER>_os_MAX_NO_COUNTER)
#error  "OIL Error: Max number COUNTERS exceeded"
#endif

/* ALARMS */
#define _os_MAX_NO_ALARM        INT_FAST8_MAX   
#if (_os_NO_ALARM>_os_MAX_NO_ALARM)
#error  "OIL Error: Max number ALARMs exceeded"
#endif

/* RESOURCES */
#define _os_MAX_NO_RESOURCE     INT_FAST8_MAX   
#if (_os_NO_RESOURCE>_os_MAX_NO_RESOURCE)
#error  "OIL Error: Max number RESOURCEs exceeded"
#endif

/* ISRS */
#define _os_MAX_NO_ISR          INT_FAST8_MAX   
#if (_os_NO_ISR>_os_MAX_NO_ISR)
#error  "OIL Error: Max number ISRs exceeded"
#endif

/* MESSAGE */
#define _os_MAX_NO_MESSAGE      INT_FAST8_MAX   
#if (_os_NO_MESSAGE>_os_MAX_NO_MESSAGE)
#error  "OIL Error: Max number MESSAGEs exceeded"
#endif

/* APPMODES */
#define _os_MAX_NO_APPMODE      INT_FAST8_MAX   
#if (_os_NO_APPMODE>_os_MAX_NO_APPMODE)
#error  "OIL Error: Max number APPMODEs exceeded"
#endif


#endif /* _H_OS_C_LIMITS */


