/******************************************************************************
**  FILE:      @(#)c_initmessage.c      1.16 04/09/15
**  DESCRIPTION:
**      Source code for 'InitMessage'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_InitMessage
#else
InitMessage
#endif
(SymbolicName msg, ApplicationDataRef data)
{
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        StatusType      ret = E_COM_ID;
        #else
        StatusType      ret = E_OK;
        #endif
       
        _os_RTOSMEM _os_MESSAGE*             msgptr = &_os_message_table[msg];
#if (_os_NO_MESSAGE > 0)

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_InitMessage);
   
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        if ( msg < _os_NO_MESSAGE && msgptr->MESSAGEPROPERTY != _os_ME_SEND_STATIC_INTERNAL )
        {
                ret = E_OK;
        #endif

        
                if (msgptr->MESSAGEPROPERTY == _os_ME_RECEIVE_QUEUED_INTERNAL)
                {
                        /* For queued receive msgs, InitMessage sets the number of received
                         * messages to zero. */
                        _os_DisableInterrupts();
                        msgptr->queuelength =0;
                        msgptr->queuestart  =0;
                        _os_EnableInterrupts();
                }
                else
                {
                        /* InitMessage can be used to initialise any unqueue msg
                         * with any legal value or msgs that are too large or complex
                         * for their initial value to be specified in the OPIL file
                         */
                        _os_SetDataReceiver(msg,(uint8_t*)data);
                
                }

        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        }
        #endif
        
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        #if (_os_COM_0_COMERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_INIT_MESSAGE,(int32_t)msg,-1,-1);
        }
        #endif
        #endif
        
        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_InitMessage);
        
#endif
        
        return ret;
}



