/******************************************************************************
 *  FILE:      @(#)c_incrementcounter.c 1.11 04/09/15
 *  DESCRIPTION:
 *      Source code for 'IncrementCounter'
 *****************************************************************************/ 
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_IncrementCounter
#else
IncrementCounter
#endif
(CounterType c_id )
{
        StatusType ret = E_OK;
#if (_os_NO_USER_COUNTER>0)

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_IncrementCounter);

        if ( c_id < 1 || c_id >=_os_NO_COUNTER )
        {
                /* not valid user counter */
                ret = E_OS_ID;
        }
        else
        {
#if (_os_NO_ALARM>0)
                _os_UpdateCounter(c_id);
#endif
        }

#if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_INC_COUNTER,(int32_t)c_id,-1,-1);
        }
#endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* _os_lock-- */

        /* system exit actions */
        _os_ServiceExit(_os_N_IncrementCounter);
        
#else
        (void)c_id;
#endif

        
        return ret;
}


