/*********************************************************************************
 *  FILE:       @(#)c_idle.c    1.1 04/09/14  
 *  DESCRIPTION:
 *  Source code for the RTOS _os_Idle task which runs at the system
 *  lowest priority.
 ********************************************************************************/

#if ( (_os_OS_0_POSTMORTEM == _os_OS_REALTIME) && (_os_OS_0_HARDLOGGING==0) )
#include "c_postmortem.h"
#include "c_target.h"
#endif

/********************************************************************************* 
 * Code for the IDLE task: It remains in a while-loop waiting for tasks 
 * with higher priority to become ready.
 * The IDLE tasks do not "count" in terms of CPU usage since it only runs
 * when no other tasks are 'ready'. Or, in other words, this task cannot
 * possibly prevent application's tasks from running, thus not affecting
 * the system's real time performance.
 * 
 * This implementation of the IDLE tasks carries out some sanity tasks such as:
 * - send the buffered real-time postmortem events (when SOFTLOGGING). 
 * - ..
 *  
 *  and then enters an state (if applicable) of lower power consumption
 *  (interrupts still being attended, obviously).
 ********************************************************************************/

void _os_Idle(void)
{
        while(1)
        {
#if ( (_os_OS_0_POSTMORTEM == _os_OS_REALTIME) && (_os_OS_0_HARDLOGGING==0) )
                /* log possible real-time buffered postmortem events */
                while(_os_SoftRTEventLog());
#endif
                /* enter (if applicable) lower power consumption */
                _os_EnterWait();
        }
}

