/************************************************************************
**  FILE:      @(#)c_gettaskstate.c     1.12 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'GetTaskState'                                  *
**      See discussion in 'c_system.c'                                  *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetTaskState
#else
GetTaskState
#endif
(TaskType TaskID,TaskStateRefType State )
{
        StatusType      ret = E_OK;
#if (_os_NO_USER_TASK>0)

        /* system entry actions */
        _os_ServiceEntry(_os_N_GetTaskState);
     
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        
        if ( TaskID >= _os_NO_TASK )
        {
                /* wrong id */
                ret = E_OS_ID;
        }
        else
        {
        #endif
                _os_DisableInterrupts();
                *State   = _os_task_table[TaskID].state;
                _os_EnableInterrupts();
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_TASK_STATE,(int32_t)TaskID,-1,-1);
        }
        #endif
        #endif

        /* system exit actions */
        _os_ServiceExit(_os_N_GetTaskState);

#else
        (void)TaskID;(void)State;
#endif
        return ret;
        
}

