/************************************************************************
**  FILE:      @(#)c_gettaskid.c        1.8 04/09/14
**  DESCRIPTION:                                                        *
**      Source code for 'GetTaskID'                                     *
**      See discussion in 'c_system.c'                                  *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetTaskID
#else
GetTaskID
#endif
(TaskRefType pid)
{  

#if (_os_NO_USER_TASK>0)
        
        /* system entry actions */
        _os_ServiceEntry(_os_N_GetTaskID);

        /************************************************************ 
         * No need for protection. Even if an ISR interrupts here
         * and another task is scheduled as a result. When 
         * scheduler resumes execution (after one or many switches)
         * the very same value for  _os_current_task prevails
         ***********************************************************/
        if (_os_current_task != (_os_RTOSMEM _os_TASK*)0)
        {
                /* no protection: this field never changes */
                *pid = _os_current_task->user_id;
        }
        else
        {
                /* There is no running task */
                *pid = INVALID_TASK;
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_GetTaskID);
        
#else
        (void)pid;
#endif  
        
        return E_OK;
}





