/************************************************************************
**  FILE:      @(#)c_getmessagestatus.c 1.11 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'GetMessageStatus'                              *
**      See discussion in 'c_system.c'                                  *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetMessageStatus
#else
GetMessageStatus
#endif
(SymbolicName msg)
{
#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        StatusType      ret     = E_COM_ID;
#else
        StatusType      ret     = E_OK;
#endif
        
#if (_os_NO_MESSAGE >0 )

        /* system entry actions */
        _os_ServiceEntry(_os_N_GetMessageStatus);
     
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        if ( msg < _os_NO_MESSAGE && 
                _os_message_table[msg].MESSAGEPROPERTY == _os_ME_RECEIVE_QUEUED_INTERNAL ) 
        {
            ret = E_OK;
        #endif

            _os_DisableInterrupts();
            if (_os_message_table[msg].queuelength == 0)
            {
                    ret = E_COM_NOMSG;
            }
            else if (_os_message_table[msg].queuelength == _os_message_table[msg].QUEUESIZE+1)
            {
                    ret = E_COM_LIMIT;
            }
            _os_EnableInterrupts();

        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        }
        #endif

        #if (_os_COM_0_COMERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_GET_MSGSTATUS,(int32_t)msg,-1,-1);
        }
        #endif
        
        /* system exit actions */
        _os_ServiceExit(_os_N_GetMessageStatus);

#else
        (void)msg;
#endif

        return ret;
}


