/************************************************************************
**  FILE:      @(#)c_getevent.c 1.13 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'GetEvent'                                      *
**      See discussion in 'c_system.c'                                  *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetEvent
#else
GetEvent
#endif
(TaskType task_id, EventMaskRefType mask)
{
        StatusType ret = E_OK;
  
        /* system entry actions */
        _os_ServiceEntry(_os_N_GetEvent);
 
#if (_os_NO_EVENT>0)

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        
        if ( task_id >= _os_NO_TASK )
        {
                ret = E_OS_ID;
        }
        else 
        {
        #endif
                _os_DisableInterrupts();
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
                if ( _os_task_table[task_id].state == SUSPENDED )
                {
                        ret = E_OS_STATE;
                }
                else
                {
        #endif
                        *mask = (EventMaskType)_os_task_table[task_id].set;
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
                }
        #endif
                _os_EnableInterrupts();
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK )
        {
                _os_LogError(ret,_os_TO_GET_EVENT,(int32_t)task_id,-1,-1);
        }
        #endif
        #endif
        
        /* system exit actions */
        _os_ServiceExit(_os_N_GetEvent);
        
#else
        (void)task_id;(void)mask;
#endif
        
        return ret;
}


