/************************************************************************
**  FILE:      @(#)c_getalarmbase.c     1.12 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'GetAlarmBase'                                  *
**      see discussion in c_system.c                                    *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetAlarmBase
#else
GetAlarmBase
#endif
(AlarmType alarm_id, AlarmBaseRefType base)
{
        StatusType ret = E_OK;
#if (_os_NO_ALARM>0)
        _os_RTOSMEM _os_COUNTER*    counter;
#endif
        
        /* system entry actions */
        _os_ServiceEntry(_os_N_GetAlarmBase);

#if (_os_NO_ALARM>0)
        counter = &_os_counter_table[_os_alarm_table[alarm_id].COUNTER];

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )

        if (  alarm_id < 0 || alarm_id >= _os_NO_ALARM ) 
        {
                /* wrong id */
                ret = E_OS_ID;
        }
        else
        {
        #endif
                /* no need for protection */
                base->maxallowedvalue   = counter->MAXALLOWEDVALUE;
                base->ticksperbase      = counter->TICKSPERBASE;
                base->mincycle          = counter->MINCYCLE;
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK )
        {
                _os_LogError(ret,_os_TO_BASE_ALARM,(int32_t)alarm_id,(int32_t)base,-1);
        }
        #endif
        #endif
       
        /* system exit actions */
        _os_ServiceExit(_os_N_GetAlarmBase);    
        
#else
        (void)alarm_id;(void)base;
#endif

        
        return ret;
}

