/************************************************************************
**  FILE:      @(#)c_getalarm.c 1.11 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'GetAlarm'                                      *
**      See discussion in 'c_system.c'                                  *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_GetAlarm
#else
GetAlarm
#endif
(AlarmType alarm_id, TickRefType base)
{
        StatusType ret  = E_OK;
#if (_os_NO_ALARM>0)
        _os_RTOSMEM _os_ALARM  *    alarm= &_os_alarm_table[alarm_id];
        TickType time ;
        
        /* system entry actions */
        _os_ServiceEntry(_os_N_GetAlarm);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        
        if (  alarm_id < 0 || alarm_id >= _os_NO_ALARM ) 
        {
                /* wrong id */
                ret = E_OS_ID;
        }
        #endif
       
        _os_DisableInterrupts();
        time= alarm->ALARMTIME;
        _os_EnableInterrupts();
        
        if ( time == 0 )
        {
                ret = E_OS_NOFUNC;
        }
        else
        {
                *base = time;
        }

        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_GET_ALARM,(int32_t)alarm_id,(int32_t)base,-1);
        }
        #endif

        /* system exit actions */
        _os_ServiceExit(_os_N_GetAlarm);
        
#else
        (void)alarm_id;(void)base;
#endif

        return ret;
}

