/******************************************************************************
**  FILE:      @(#)c_clearevent.c       1.15 04/09/15
**  DESCRIPTION:
**      Source code for 'ClearEvent'
 *****************************************************************************/ 
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_ClearEvent
#else
ClearEvent
#endif
(EventMaskType mask)
{
        StatusType ret = E_OK;
#if (_os_NO_EVENT>0)

        /* system entry actions */
        _os_ServiceEntry(_os_N_ClearEvent);
     
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if ( !(_os_current_task->events & mask) )
        {
                /* this mask does not contain any of the task's possible events */
                ret = E_OS_SYS_VALUE;
        }
        else if ( _os_IsInterruptLevel() )
        {
                /* Call at interrupt level */
                ret = E_OS_CALLEVEL;
        }
        else
        {
        #endif
                
                _os_DisableInterrupts();
                /* let us clear the given events */
                _os_current_task->set &= (_os_EVENTMASKTYPE)~mask;
                _os_EnableInterrupts();

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_CLEAR_EVENT,(int32_t)mask,-1,-1);
        }
        #endif
        #endif

        /* system exit actions */
        _os_ServiceExit(_os_N_ClearEvent);
        
#else
        (void)mask;
#endif

        return ret;
}

