/******************************************************************************
 *  FILE:      @(#)c_chaintask.c        1.29 04/10/18
 *  DESCRIPTION:
 *      Source code for 'ChainTask'
 *****************************************************************************/ 
#include "c_common.h"
#include "c_target.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif
        
StatusType
#if (_os_SIA>0)
_os_ChainTask
#else
ChainTask
#endif
(TaskType TaskID)
{       
        StatusType              ret     = E_OK;
 #if (_os_NO_USER_TASK>0)
        _os_RTOSMEM _os_TASK*               newtask = &_os_task_table[TaskID];

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_ChainTask);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        /* not chain with invalid tasks */
        if ( TaskID >= _os_NO_TASK )
        { 
                ret = E_OS_ID;
        }
        else
        /* neither from interrupt level */
        if ( _os_IsInterruptLevel()  )
        {
                ret = E_OS_CALLEVEL;
        }
        else
        /* check if current task owns non-internal resources */
         if ( _os_current_task->res != _os_INVALID_RES                  &&
              _os_resource_table[_os_current_task->res].RESOURCEPROPERTY == _os_RE_STANDARD
            )
         {
                 /* no concurrency problems since only '_os_current_task' can
                  * update '_os_current_task->res' */
                  ret = E_OS_RESOURCE;    
         }
         
         if (ret==E_OK)
         {
        #endif

                _os_SuspendOS();
                
                #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                        /* check that the succeding task is not the current one */
                if (_os_current_task != newtask )
                 {
                #endif
                        /* check number of activations */
                         if (newtask->repeat >= newtask->ACTIVATION )
                         {
                                ret = E_OS_LIMIT;
                         }
                #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                }
                #endif
                
                if (ret == E_OK 
                    #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                        && _os_current_task != newtask 
                   #endif
                   )
                {
                        #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                        _os_LogPlaybackEvent(TASK_TERMINATE,
                                (uint8_t)_os_current_task->user_id,
                                0);
                        #endif
        
                        /* current task */
                        if ( _os_current_task->repeat--==1 )
                        {
                                /* remove task from 'ready_to_run' queue */
                                _os_RemoveCurrentTask();
                                /* the task shall be suspended */
                                _os_current_task->state=SUSPENDED;
                        }
                        else
                        {
                                /* the task shall be ready */
                                _os_current_task->state=READY;
                        }
                        
                        #if (_os_OS_0_ORTI>0)
                        _os_current_task->pc = (uintptr_t)_os_current_task->ADDRESS;
                        #endif
                        
                        /* new task */
                        if ( newtask->state == SUSPENDED )
                        {
                                /* Only after the current task has been removed
                                 * we can add the new task to its priority level
                                 * (they could be at the same level). */
                                _os_SetTaskReadyFirst(newtask);
                        }       
                        
                        newtask->repeat++;

                       /* From now on, the history of the task becomes
                        * irrelevant ('scheduling' shall happen next).
                        * The target routine (_os_ChangeStack()) decides
                        * where to keep storing the next locals/parameters/..
                        * until a new task is again scheduled (in 'GoToTask').
                        * The reason:
                        * In some targets, (ex. M32C), the _os_TargetResetTaskContext 
                        * routine prepares the next context of the current task
                        * for future activations in the task's stack area. 
                        * Did we not change here the stack, storing locals from 
                        * here and until the scheduler could lead us to data
                        * corruption in the task context area.
                        * Obviously:
                        * From here onwards in this routine, no use of 
                        * locals is allowed.
                        */
                        _os_ChangeStack();
                
                        /* Let us now prepare the context of the running task
                        * for future activations. */
                        _os_TargetResetTaskContext(_os_current_task->user_id);
                        
                        #if (_os_OS_0_POSTTASKHOOK==1)
                        _os_SETPOSTHOOK();
                        PostTaskHook();
                        _os_CLRPOSTHOOK();
                        #endif

                        #if (_os_OS_0_STACKMONITOR ==1)
                        _os_StackMonitor();
                        #endif
                       
                        /* system exit actions */
                        _os_ServiceExit(_os_N_ChainTask);
                        
                        #if (_os_OS_0_ORTI>0)   
                        /* log cycles spent by terminating task */
                        _os_UpdateTaskCycles();
                        #endif

                        /* there is no running task */
                        _os_current_task = (_os_RTOSMEM _os_TASK *)0;                   
                        
                        /* releases scheduler (for non-preempt) */
                        _os_lock = _os_SCHEDULABLE;
                        
                        _os_ResumeOS();
               
                        _os_Schedule();
                        
                } /* terminate */
        
                _os_ResumeOS();
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )               
        }
        #endif

        
        #if (_os_OS_0_ERRORHOOK==1)
        if (ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_CHAIN_TASK,(int32_t)TaskID,-1,-1);
        }
        #endif
        
        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* _os_lock-- */
        
        /* system exit actions */
        _os_ServiceExit(_os_N_ChainTask);

#else
        (void)TaskID;
#endif

        return ret; 
}



