/******************************************************************************
 *  FILE:      @(#)c_cancelalarm.c      1.16 04/09/16
 *  DESCRIPTION:
 *      Source code for 'CancelAlarm'
 *****************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_CancelAlarm
#else
CancelAlarm
#endif
(AlarmType alarm_id)
{
        StatusType ret = E_OK;
#if (_os_NO_ALARM>0)
        _os_RTOSMEM _os_ALARM*      alarm = (_os_RTOSMEM _os_ALARM*)&_os_alarm_table[alarm_id];
    
        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_CancelAlarm);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if (  alarm_id < 0 || alarm_id >= _os_NO_ALARM )
        {
                /* wrong id */
                ret = E_OS_ID;
        }
        else
        {
        #endif

        _os_SuspendOS();
       
        if ( alarm->ALARMTIME==0 && alarm->CYCLETIME==0)
        {
                ret = E_OS_NOFUNC;
        }
        else
        {
                if (alarm->status == _os_AL_RUNNING)
                {
                        _os_DeleteAlarm(alarm);
                        alarm->status = _os_AL_STOPPED;
                }
                else if (alarm->status != _os_AL_BUSY)
                {
                        alarm->ALARMTIME  = 0;
                        alarm->CYCLETIME  = 0;
                }
        }
        _os_ResumeOS();

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_CANCEL_ALARM,(int32_t)alarm_id,-1,-1);
        }
        #endif  

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_CancelAlarm);
        
#else
        (void)alarm_id;
#endif
        
        return ret;
}


