/******************************************************************************
 *  FILE:      @(#)c_activatetask.c     1.18 04/10/18
 *  DESCRIPTION:
 *      Source code for 'ActivateTask'
 *****************************************************************************/         
#include "c_common.h"
#include "c_target.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif

StatusType
#if (_os_SIA>0)
_os_ActivateTask
#else
ActivateTask
#endif
(TaskType TaskID)
{
        StatusType      ret = E_OK;
#if (_os_NO_USER_TASK>0)
        _os_RTOSMEM _os_TASK*       task =(_os_RTOSMEM _os_TASK*)&_os_task_table[TaskID];
#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#if (_os_NO_ISR>0)
         uint8_t id;
#endif
#endif       
        _os_lock++;

        /* system actions */
        _os_ServiceEntry(_os_N_ActivateTask);

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if ( TaskID >= _os_NO_TASK )
        { 
                /* wrong id */
                ret = E_OS_ID;
        }
        else
        {
        #endif
                
                _os_SuspendOS();  
                
                if ( task->state == SUSPENDED )
                {
                        /* Add task 'tcb' at the end of the 
                         * 'ready to run' queue of its priority level.
                         */
                        _os_SetTaskReady(task);                        
                        task->repeat++;
                }
                else if (task->repeat < task->ACTIVATION )
                {
                        task->repeat++;
                }
                else
                {
                        ret = E_OS_LIMIT;
                }
                
                #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                # if (_os_NO_ISR>0)
                        if (_os_IsInterruptLevel())
                        {
                                id = (uint8_t)(_os_current_isr - &_os_isr_table[0])/sizeof(_os_ISR);
                                _os_LogPlaybackEvent(ISR_ACTIVATE,
                                                (uint8_t)id,
                                                (uint32_t)TaskID);
                        }
                        else
                        {
                #endif
                                _os_LogPlaybackEvent(TASK_ACTIVATE,
                                                (uint8_t)_os_current_task->user_id,
                                                (uint32_t)TaskID);
                # if (_os_NO_ISR>0)
                        }
                #endif
                #endif
                
                _os_ResumeOS();

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_ERRORHOOK==1)
        if (ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_ACTIVATE_TASK,(int32_t)TaskID,-1,-1);
        }
        #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* _os_lock-- */

        /* system exit actions*/
        _os_ServiceExit(_os_N_ActivateTask);
        
#else
        (void)TaskID;
#endif
        return ret;
}



