/**************************************************************************
**                                                                        *
**  FILE        :  wmemchr.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wmemchr routine.                       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

/*
 * Locate the first occurence of c in the initial n wide characters of the
 * object pointed to by s.
 *
 * Return a pointer to the located wide character, or a null pointer if the
 * wide character does not occur in the object.
 */
wchar_t*
wmemchr( const wchar_t* s, wchar_t c, size_t n )
{
        for ( ; n > 0; n--, s++ )
        {
                if ( *s == c )
                {
                        return (wchar_t *) s;
                }
        }

        return NULL;
}
