/**************************************************************************
**                                                                        *
**  FILE        :  wcsspn.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcsspn routine.                        *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

/*
 * Compute the length of the maximum initial segment of the wide string
 * pointed to by s1 which consists entirely of wide characters from the
 * wide string pointed to by s2.
 *
 * Return the length of the segment.
 */
size_t
wcsspn( const wchar_t* s1, const wchar_t* s2)
{
        size_t count = 0;

        if ( s1 && s2 )
        {
                for ( ; *s1; s1++, count++ )
                {
                        if ( !wcschr( s2, *s1 ) )
                        {
                                break;
                        }
                }
        }

        return count;
}
