/**************************************************************************
**                                                                        *
**  FILE        :  wcsrchr.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcsrchr routine.                       *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

/*
 * Locate the last occurence of c in the wide string pointed to by s. the 
 * terminating null wide character is considered to be part of the wide 
 * string.
 *
 * Return a pointer to the located wide character if found; otherwise
 * return a null pointer.
 */
wchar_t *wcsrchr(const wchar_t *s, wchar_t c)
{
        wchar_t *pts = NULL;

        if (s)
        {
                /* Check for the null wide character.
                 */
                if (c == (wchar_t) 0)
                {
                        while (*s)
                        {
                                s++;
                        }
                        pts = (wchar_t *) s;
                }
                else
                {
                        for (; *s; s++)
                        {
                                if (*s == c)
                                {
                                        pts = (wchar_t *) s;
                                }
                        }
                }
        }

        return pts;
}

