/**************************************************************************
**                                                                        *
**  FILE        :  vswscanf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for vswscanf() routine.                    *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int vswscanf( const wchar_t * restrict s, const wchar_t * restrict format, va_list arg )
{
        struct _io      buf;

        buf.fp = NULL;
        buf.ptr = (char *) s;
        buf.end = (char *)(s + wcslen( s ));
        return _dowscan(&buf, format, arg);
}

#endif
