/**************************************************************************
**                                                                        *
**  FILE        :  vsnprintf.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for vsnprintf() routine.                   *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <limits.h>
#include <io.h>

#pragma weak    _doprint

int vsnprintf( char * restrict s, size_t n, const char * restrict format, va_list arg )
{
        int             chars;
        struct _io      buf;

        chars = 0;
        if (n)
        {
                buf.fp = NULL;
                buf.ptr = s;
                buf.end = s + n - 1;
                chars = _doprint( & buf, format, arg );
                *buf.ptr = 0;
        }
        return chars;
}
