/**************************************************************************
**                                                                        *
**  FILE        :  vprintf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for vprintf() routine.                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

#pragma weak    _doprint

int vprintf( const char * restrict format, va_list arg )
{
        int             chars;
        struct _io      io;

        io.fp = stdout;
        chars = _doprint( &io, format, arg );
        return (ferror(stdout) ? EOF : chars);
}
