/**************************************************************************
**                                                                        *
**  FILE        :  swscanf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for swscanf() routine.                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int swscanf( const wchar_t * restrict s, const wchar_t * restrict format, ... )
{
        va_list         ap;
        int             items;
        struct _io      buf;

        va_start( ap, format );
        buf.fp = NULL;
        buf.ptr = (char *) s;
        buf.end = (char *)(s + wcslen( s ));
        items = _dowscan( & buf, format, ap );
        va_end( ap );
        return items;
}

#endif
