/**************************************************************************
**                                                                        *
**  FILE        :  scalbln.c                                              *
**                                                                        *
**  DESCRIPTION :  The scalbln() function.                                *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

/*****************************************************************************
|*
|* FUNCTION     : scalbln
|*
|* DESCRIPTION  :
|*
|*     Same as scalbn, except that second parameter is long.
|*
*/
#ifndef __SINGLE_FP__
#pragma alias   scalbln         = _scalbln_dpf
#pragma alias   scalblnl        = _scalbln_dpf
static
double  _scalbln_dpf( double v, long int pwr )
{
        double2longs_t  u;
        unsigned long   hi;
        long int        exponent;

        u.d     = v;
        hi      = u.s.hi;

        exponent        = GET_DOUBLE_EXPONENT( hi );
        exponent        += pwr;
        hi              = STRIP_DOUBLE_EXPONENT( hi );
        hi              = PUT_DOUBLE_EXPONENT( hi, exponent );

        u.s.hi  = hi;
        return u.d;
}
#endif
