/**************************************************************************
**                                                                        *
**  FILE        :  puts.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for puts() routine                         *
**                 Writes a complete string to standard output            *
**                 The string is terminated by a newline.                 *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

int     puts( const char * s )
{
        register int c;

        while ( *s != '\0' )                    /* write until null character */
        {
                c = *s++;
                if ( putc( c, stdout ) != c )
                {
                        return EOF;             /* error */
                }
        }
        /* complete with a newline character */
        return putc( '\n', stdout ) == '\n' ? 0 : EOF;
}
