/**************************************************************************
**                                                                        *
**  FILE        :  pow.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for pow() routine                          *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   powl    = _pow_dpf
#pragma alias   pow             = _pow_dpf


static
double
_pow_dpf( double arg1, double arg2 )
{
        long    l;

        if( arg1 <= 0.0 )
        {
                if( arg1 == 0.0 )
                {
                        if( arg2 <= 0.0 )
                                errno = EDOM;
                        return( 0.0 );
                }
                l = arg2;
                if( l != arg2 )
                {
                        errno = EDOM;
                        return( 0.0 );
                }
                arg1 = exp( arg2 * log( -arg1 ) );
                return( (l & 1) ? -arg1 : arg1 );
        }
        return( exp( arg2 * log( arg1 ) ) );
}

#endif

