/**************************************************************************
**                                                                        *
**  FILE        :  memcpy.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for memcpy() routine                       *
**                 Copies data from default memory to default memory      *
**                 Does not check for overlapping spaces.                 *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>


void *
memcpy( void * restrict s, register const void * restrict ct,
        register size_t n )
{
        register char *so = s;

        for( ; n--; *so++=*(char *)ct, ct = (char *)ct + 1 )
                ;
        return( (void *)s );
}
