/**************************************************************************
**                                                                        *
**  FILE        :  log10.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for log10() routine                        *
**                 Computes the 'logarithm' for the given value           *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   log10l  = _log10_spf
#pragma alias   log10           = _log10_spf
#endif
#pragma alias   log10f  = _log10_spf


#define LN10     2.302585092994045684f

static
float
_log10_spf( float arg )
{
        float   log_result;

        log_result      = log( arg );

        /*
         * Here we can't test on errno == ERANGE since errno is not reset
         * on success. Also do not reset errno here first, since that
         * is not expected behavior of a math function.
         */
        if ( log_result == -HUGE_VALF )
        {
                return log_result;
        }

        return log_result / LN10;
}


