/**************************************************************************
**                                                                        *
**  FILE        :  locale.c                                               *
**                                                                        *
**  DESCRIPTION :  Skeleton functions for localization.                   *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <limits.h>
#include <locale.h>
#include <string.h>

char *setlocale( int category, const char *locale )
{
        (void) category;

        if      (  ! locale
                || ! *locale
                || strcmp( locale, "C" ) == 0
                )
        {
                return (char *)"C";
        }
        return NULL;
}

struct lconv *localeconv( void )
{
        static struct lconv lc;

        lc.decimal_point     = (char *)".";
        lc.thousands_sep     = (char *)"";
        lc.grouping          = (char *)"";
        lc.int_curr_symbol   = (char *)"";
        lc.currency_symbol   = (char *)"";
        lc.mon_decimal_point = (char *)"";
        lc.mon_thousands_sep = (char *)"";
        lc.mon_grouping      = (char *)"";
        lc.positive_sign     = (char *)"";
        lc.negative_sign     = (char *)"";
        lc.int_frac_digits   = CHAR_MAX;
        lc.frac_digits       = CHAR_MAX;
        lc.p_cs_precedes     = CHAR_MAX;
        lc.p_sep_by_space    = CHAR_MAX;
        lc.n_cs_precedes     = CHAR_MAX;
        lc.n_sep_by_space    = CHAR_MAX;
        lc.p_sign_posn       = CHAR_MAX;
        lc.n_sign_posn       = CHAR_MAX;
        return(&lc);
}
