/**************************************************************************
**                                                                        *
**  FILE        :  iswalpha.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswalpha routine.                      *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#undef iswalpha

/*
 * Test for any wide character for which iswupper or iswlower is true, or
 * any wide character that is one of wide characters for which none of
 * iswcntrl, iswdigit, iswpunct or iswspace is true.
 * Return 0 on failure.
 */
int iswalpha(wint_t wc)
{
        return iswctype(wc, _alpha);
}

