/**************************************************************************
**                                                                        *
**  FILE        :  fss_init.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for _fss_init() routine.                   *
**                 This function takes care of opening file descriptors   *
**                 0, 1 and 2, and associating them with VIO stream 0 of  *
**                 CrossView Pro.                                         *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <fss.h>
#include <fcntl.h>


void    _fss_init ( int fd, int is_close )
{
        static  char    init[3];
        static  char    busy;

        if      ( busy )
        {
                return;         /* prevent recursion */
        }
        /*
         * The following test is to prevent the VIO window from popping
         * up when an application that didn't do any I/O reaches exit().
         */
        if      ( is_close && fd < 3 )
        {
                init[fd] = 1;
                return;
        }
        busy = 1;
        if      ( ! init[0] )
        {
                init[0] = 1;
                (void) _host_open( "FSS_window0", O_RDONLY );   /* use FSS_window0 for input (stdin)
                                                                 * FSS_window0X where x = vio stream
                                                                 * number in crossview or rungdi
                                                                 */
        }
        if      ( ! init[1] )
        {
                init[1] = 1;
                (void) _host_open( "FSS_window0", O_WRONLY );   /* use FSS_window0 for output (stdout)*/
        }
        if      ( ! init[2] )
        {
                init[2] = 1;
                (void) _host_open( "FSS_window0", O_WRONLY );   /* use FSS_window0 for error messages
                                                                 * (stderr). Note that stdout and stderr
                                                                 * are send to the same window so cross
                                                                 * view and rungdi are unable to sepparate
                                                                 * between stdout and stderr. This is done
                                                                 * so "hello world\n" doesn't open 2 vio
                                                                 * windows (stdout and stderr) while only
                                                                 * one is needed (stdout).
                                                                 */
        }
        busy = 0;
}
