/**************************************************************************
**                                                                        *
**  FILE        :  fss_getcwd.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for getcwd() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to retrieve the current directory on the host.     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fss.h>

#ifndef FSS_MINIMAL
char*   getcwd ( char * buf, size_t size )
{
        FSS_BUF* b = & _fss_buffer;
        int     retval;

        if      ( size >= FSS_MAXBUF )
        {
                size = FSS_MAXBUF;
        }
        b->buff_size = offsetof(FSS_BUF,u2) + sizeof(int);
        b->u1.call_id = FSS_GETCWD;
        b->u2.getcwd.size = size;
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval <= 0 ) /* ! */
        {
                errno = b->u2.errno;
                return (char*) 0;
        }
        else
        {
                strcpy( buf, b->u2.getcwd.path );
                return buf;
        }
}
#endif
