/**************************************************************************
**                                                                        *
**  FILE        :  fss__read.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for _read() routine.                       *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to read a sequence of characters from a file.      *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

#pragma weak _read
#pragma alias _read = _host_read

int     _host_read ( _fd_t fd, void *buffer, size_t count )
{
        FSS_BUF* b = & _fss_buffer;
        int     retval;

        _fss_init( fd, 0 );
#ifndef FSS_MINIMAL
        if      ( count <= FSS_MAXBUF )
        {
                b->buff_size = (int)offsetof(FSS_BUF,u2) + 2 * (int)sizeof(int);
                b->u1.call_id = FSS_READ_SHORT;
                b->u2.read_short.in.fd = fd;
                b->u2.read_short.in.count = (int)count;
        }
        else
#endif
        {
                b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(b->u2.read_long);
                b->u1.call_id = FSS_READ_LONG;
                b->u2.read_long.fd = fd;
                b->u2.read_long.count = (int)count;
                b->u2.read_long.buffer = buffer;
        }
        _fss_break();           /* pass control to CrossView */
        retval = b->u1.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
#ifndef FSS_MINIMAL
        else if ( count <= FSS_MAXBUF )
        {
                memcpy( buffer, b->u2.read_short.out.buffer, retval );
        }
#endif
        return retval;
}
