/**************************************************************************
**                                                                        *
**  FILE        :  fss__lseek.c                                           *
**                                                                        *
**  DESCRIPTION :  Source file for _lseek() routine.                      *
**                 Use the file system simulation feature of CrossView    *
**                 Pro to seek in a file on the host platform.            *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stddef.h>
#include <string.h>
#include <errno.h>
#include <fss.h>

#pragma weak _lseek
#pragma alias _lseek = _host_lseek

long    _host_lseek ( _fd_t fd, long offset, _whence_t whence )
{
        FSS_BUF* b = & _fss_buffer;
        long    retval;

        _fss_init( fd, 0 );
        b->buff_size = (int)offsetof(FSS_BUF,u2) + (int)sizeof(b->u2.lseek);
        b->u1.call_id = FSS_LSEEK;
        b->u2.lseek.in.fd = fd;
        b->u2.lseek.in.offset = offset;
        b->u2.lseek.in.whence = whence;
        _fss_break();           /* pass control to CrossView */
        retval = b->u2.lseek.out.retval;
        if      ( retval < 0 )
        {
                errno = b->u2.errno;
        }
        return retval;
}
