/**************************************************************************
**                                                                        *
**  FILE        :  fscanf.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for fscanf() routine.                      *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

int fscanf( FILE * restrict fp, const char * restrict format, ... )
{
        va_list ap;
        int     items;

        va_start( ap, format );
        items = _doscan( (struct _io *)&fp, format, ap );
        va_end( ap );
        return (ferror(fp) ? EOF : items);
}
