/**************************************************************************
**                                                                        *
**  FILE        :  fread.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fread() routine                        *
**                 Reads a number of objects from the given stream        *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

size_t  fread ( void * restrict ptr, size_t size, size_t nobj,
                FILE * restrict fp )
{
        size_t  objs = 0;
        int     i;
        int     c;
        char    *cp;

        if ( size )
        {
                cp = (char *) ptr;
                for     ( ; objs < nobj; objs++ )
                {
                        for     ( i = 0; i < size; i++ )
                        {
                                c = getc( fp );
                                if      ( c == EOF )
                                {
                                        return objs;
                                }
                                *cp++ = (char) c;
                        }
                }
        }
        return objs;
}
