/**************************************************************************
**                                                                        *
**  FILE        :  fprintf.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for fprintf() routine.                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <io.h>

#pragma weak    _doprint

int fprintf( FILE * restrict fp, const char * restrict format, ... )
{
        va_list ap;
        int     chars;

        va_start( ap, format );
        chars = _doprint( (struct _io *)&fp, format, ap );
        va_end( ap );
        return (ferror(fp) ? EOF : chars);
}
