/**************************************************************************
**                                                                        *
**  FILE        :  floor.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for floor() routine                        *
**                 Rounds value to the largest integer value not greater  *
**                 than the given value                                   *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>

#ifdef __SINGLE_FP__
#pragma alias   floorl  = _floor_spf
#pragma alias   floor           = _floor_spf
#endif
#pragma alias   floorf  = _floor_spf


static
float
_floor_spf( float d )
{
        if ( d < 0.0f )
        {
                if( modff( -d, &d ) != 0.0f )   /* When fractional part is not 0.0 */
                        d += 1.0f;              /* Round up */
                d = -d;
        }
        else
                modff( d, &d );

        return( d );
}


