/**************************************************************************
**                                                                        *
**  FILE        :  floor.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for floor() routine                        *
**                 Rounds value to the largest integer value not greater  *
**                 than the given value                                   *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>

#ifndef __SINGLE_FP__
#pragma alias   floorl  = _floor_dpf
#pragma alias   floor           = _floor_dpf


static
double
_floor_dpf( double d )
{
        if ( d < 0.0 )
        {
                if( modf( -d, &d ) != 0.0 )     /* When fractional part is not 0.0 */
                        d += 1.0;               /* Round up */
                d = -d;
        }
        else
                modf( d, &d );

        return( d );
}

#endif

