/**************************************************************************
**                                                                        *
**  FILE        :  fgets.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fgets() routine                        *
**                 Reads all characters from the given stream until a     *
**                 EOF or newline is found                                *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

char *  fgets( char * restrict s, int n, FILE * restrict fp )
{
        register int c;
        register char *cs;

        c = !EOF;       /* initialise for n <= 0 */
        cs = s;
        while ( (--n > 0) && ((c = fgetc( fp )) != EOF) )
        {       /* read until end of file or until 'n-1' characters are read */
                *cs++ = (char) c;
                if ( c == '\n' )        /* Read until newline is found */
                {
                        break;
                }
        }
        if ( (c == EOF) && (cs == s) )  /* end of file, and no characters have been read */
        {
                return NULL;
        }
        *cs = '\0';                     /* append a '\0' character */
        return s;
}
