/**************************************************************************
**                                                                        *
**  FILE        :  cstart.c                                               *
**                                                                        *
**  DESCRIPTION :                                                         *
**                                                                        *
**      The system startup code initializes the Program Status Word (PSW),*
**      the system Stack Pointer (SP), the vitual stack pointer (_SP) and *
**      the application C variables.                                      *
**                                                                        *
**      When linking your C modules with the library, you automatically   *
**      link the object module, containing the C startup code. This       *
**      module is called cstart.obj and is present in every C library     *
**      (once for every compiler model).                                  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef         P0
# define        P0      (*(__bsfr volatile unsigned char *)0x80)
#endif
#ifndef         SP
# define        SP      (*(__sfr  volatile unsigned char *)0x81)
#endif
#ifndef         ROMSIZE
# define        ROMSIZE (*(__sfr  volatile unsigned char *)0x8F)
#endif
#ifndef         P1
# define        P1      (*(__bsfr volatile unsigned char *)0x90)
#endif
#ifndef         XP
# define        XP      (*(__sfr  volatile unsigned char *)0x9F)
#endif
#ifndef         P2
# define        P2      (*(__bsfr volatile unsigned char *)0xA0)
#endif
#ifndef         P3
# define        P3      (*(__bsfr volatile unsigned char *)0xB0)
#endif
#ifndef         PSW
# define        PSW     (*(__bsfr volatile unsigned char *)0xD0)
#endif

#ifndef         XPREG
# define        XPREG   XP
#endif
#ifndef         XPAGE
# define        XPAGE   0
#endif

#ifndef         IROMBLOCKS
# define        IROMBLOCKS      16
#endif

extern void _init( void );
extern int   main( int argc );
extern void  exit( int );
#pragma weak    exit
#pragma extern  _Exit

extern  char    __idata _lc_bs[];               /* system stack begin label */
#if __MODEL__=='l' || __MODEL__=='a'
# if __MODEL__=='a'
#  define       VSTACK_SPACE    __pdata
#  define       VSTACK_LABEL    _lc_ue_vstack_pdata
# else
#  define       VSTACK_SPACE    __xdata
#  define       VSTACK_LABEL    _lc_ue_vstack_xdata
# endif
extern  char    VSTACK_SPACE    * __data _SP;
extern  char    VSTACK_SPACE    VSTACK_LABEL[]; /* virtual stack end label */
#endif


/* Force this section to be named '_start', it then will be located
 * in the first block of 256 bytes in code space by using LSL.
 */
#pragma section code=-f
/* Disabled waring, because the interrupt interrupt function _start does
 * not need to save register R0..7,A,B,DPL,DPH and PSW.
 */
#pragma warning 796
__interrupt(0x0) __frame() void _start( void )
{
        PSW = 0;                                /* select register bank 0 */
        XPREG = XPAGE;                          /* needed for when using __pdata */
        ROMSIZE = IROMBLOCKS;                   /* size internal Program memory */
        SP = (unsigned char)_lc_bs;             /* initialize stack pointer */
#if __MODEL__ == 'l' || __MODEL__ == 'a'
        _SP = VSTACK_LABEL-1;                   /* initialize 'virtual stack' pointer */
#endif
        _init();                                /* initialize C variables */
        exit( main(0) );
}
