/**************************************************************************
|*
|*  File:         clock.c
|*
|*  Version:       1.3
|*
|*  Description :  Source file for clock() routine
|*                 This function will only work when using the
|*                 XVW Pro Simulator as it uses the SFRs 0xC1 to 0xC4
|*                 to get the value of the cycle counter (equals the
|*                 $CCNT variable in XVW).
|*                 If you want to use it in a real-time application
|*                 you should rewrite the clock() function so it
|*                 accesses the correct Timer SFRs.
|*
|*  Copyright   :  2001-2004 Altium BV
|*
 *************************************************************************/

#include <time.h>

#define CYCLES0 (*(__sfr volatile unsigned char *)0xc1)

/* prevent 'missing return' warning */
#pragma warning 545

clock_t
clock( void )
{
        CYCLES0 = 1;

        __asm("MOV R7,0C1H");
        __asm("MOV R6,0C2H");
        __asm("MOV R5,0C3H");
        __asm("MOV R4,0C4H");
}
