/**************************************************************************
**                                                                        *
**  FILE        :  atexit.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for atexit() routine.                      *
**                 Registers the functions (with a maximum of 32)         *
**                 which should be executed on 'exit'.                    *
**                 The routine '_doexit()' is used by the 'exit()'        *
**                 routine to call all necessary functions.               *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>

#pragma extern  exit

#define MAXFUNC         32
typedef void (* FUNCPTR)( void );

static unsigned char    _atexitnr = 0;
static FUNCPTR          _atexitarr[MAXFUNC];

/* Store the routine to execute at 'exit()' */
int     atexit( void (* ptr)( void ) )
{
        if ( _atexitnr == MAXFUNC )
        {
                return 1;
        }
        _atexitarr[_atexitnr++] = ptr;
        return 0;
}

/* Execute all stored functions, called by 'exit()' */
void    _doexit( void )
{
        int     i;

        for ( i = _atexitnr; i > 0; i-- )
        {
                _atexitarr[i-1]();      /* Call the stored function */
        }
}
