/**************************************************************************
**                                                                        *
**  FILE        :  atanhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The atanh() function.                                  *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * atanh(x)
 *
 * Edwards
 *
 * ISO F.9.2.3 defines exceptions. These should be handled here,
 * but for now we rely on log and divide to do the right thing.
 */
extern  float           atanhf(float x)
{
        if (x == 0.0f)
        {
                return x;
        }
#if 0
        // x == 1 -> return infinity, raise divide-by-zero exception.
        // x == -1 -> return -infinity, raise divide-by-zero exception.
        // |x| > 1 -> return NaN, raise invalid FP exception.
#endif
        return logf((1.0f+x)/(1.0f-x))/2.0f;
}
