/**************************************************************************
**                                                                        *
**  FILE        :  _signbitf.c                                            *
**                                                                        *
**  DESCRIPTION :  Determines whether FP number has signbit set.          *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

#ifdef  __SINGLE_FP__
#pragma alias   _signbit                = _signbit_spf
#pragma alias   _signbitl               = _signbit_spf
#endif
#pragma alias   _signbitf               = _signbit_spf
static
int     _signbit_spf( float f )
{
        float2long_t    u;
        unsigned long   l;

        u.f     = f;
        l       = u.l;

        return GET_FLOAT_SIGN( l );
}
