/**************************************************************************
**                                                                        *
**  FILE        :  _signbit.c                                             *
**                                                                        *
**  DESCRIPTION :  Determines whether FP number has signbit set.          *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

#ifndef __SINGLE_FP__
#pragma alias   _signbit                = _signbit_dpf
#pragma alias   _signbitl               = _signbit_dpf
static
int     _signbit_dpf( double d )
{
        double2longs_t  u;
        unsigned long   hi;
        unsigned long   lo;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;
        lo      = u.s.lo;

        return GET_DOUBLE_SIGN( hi );
}
#endif
