/**************************************************************************
**                                                                        *
**  FILE        :  _issubnormal.c                                         *
**                                                                        *
**  DESCRIPTION :  Determines if FP number is subnormal.                  *
**                 Does not test for NaN or infinity.                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>

#ifndef __SINGLE_FP__
#pragma alias   _issubnormal            = _issubnormal_dpf
#pragma alias   _issubnormall           = _issubnormal_dpf
static
int     _issubnormal_dpf( double d )
{
        double2longs_t  u;
        unsigned long   hi;
        unsigned long   lo;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;
        lo      = u.s.lo;

        return GET_DOUBLE_EXPONENT( hi ) == MIN_DOUBLE_BIASED_EXP &&
                ( GET_DOUBLE_HI_MANTISSA( hi ) || GET_DOUBLE_LO_MANTISSA( lo ) ) &&
                !( GET_DOUBLE_EXPONENT( hi ) & ( 1L << (DOUBLE_FRACTION_SIZE - 32 - 1) ) );
}
#endif
