/**************************************************************************
**                                                                        *
**  FILE        :  _dowscan_int.c                                         *
**                                                                        *
**  DESCRIPTION :  "int" version of the _dowscan() function               *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

#pragma alias                   __wscanf_int2   = _dowscan

#pragma weak                    _getwflt
#pragma extern                  _weakstub

#define WIDE                    1
#define DOSCAN                  _dowscan
#define GETFLOAT                _getwflt
#define ISSPACE                 iswspace
#define ISDIGIT                 iswdigit
#define ISXDIGIT                iswxdigit
#define TOUPPER                 towupper
#define FGETC                   _io_getwc
#define UNGETC                  _io_ungetwc
#define LITERAL(s)              L ## s
#define E_O_F                   WEOF

typedef wchar_t                 char_t;
typedef wchar_t                 uchar_t;
typedef wint_t                  int_t;

typedef unsigned int            uint_value_t;
typedef signed int              sint_value_t;
#define VALUE_MAX               INT_MAX
#define VALUE_MIN               INT_MIN
#define UVALUE_MAX              UINT_MAX

#include "_doscan.h"

#endif
