/**************************************************************************
**                                                                        *
**  FILE        :  _dowprin_int.c                                         *
**                                                                        *
**  DESCRIPTION :  "int" version of the _dowprint() function              *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

#pragma alias                   __wprintf_int2  = _dowprint

#pragma weak                    _dowflt
#pragma extern                  _weakstub

#define WIDE                    1
#define DOPRINT                 _dowprint
#define DOFLT                   _dowflt
#define FPUTC                   _io_putwc
#define STRLEN                  wcslen
#define LITERAL(s)              L ## s

typedef wchar_t                 char_t;
typedef wchar_t                 uchar_t;
typedef wint_t                  int_t;

typedef signed int              sint_value_t;
typedef unsigned int            uint_value_t;
typedef long double             float_value_t;

#include "_doprint.h"

#endif
