/* @(#)uio.h    1.3 */
/*
 * Unified I/O.
 */

#ifndef UIO_H
#define UIO_H

#include <stddef.h>
#include <stdint.h>
#include <io.h>
#include <osek/ioreq.h>

typedef uint_least8_t   driver_t;       /* driver number */
typedef uint_least8_t   device_t;       /* opaque device handle, driver specific */

typedef struct
{
        int_least8_t    (*open)(const char *, uint_least16_t);          /* optional (default returns 0) */
        void            (*read)(device_t, ioreq_t *);
        void            (*write)(device_t, ioreq_t *);
        long            (*lseek)(device_t, long, uint_least8_t);        /* optional (default returns -ESPIPE) */
        int_least8_t    (*close)(device_t);                             /* optional (default returns 0) */
} uio_t;

/*
 * Initialization, to be called from StartupHook().
 */
extern  void            uio_config(void);

/*
 * These functions are thread safe. Instead of setting the global errno
 * variable they return negative values for errors (-errno).
 */
extern  _err_t          uio_open(const char *pathname, _open_flags_t flags);
extern  int             uio_read(_fd_t fd, void *buffer, size_t nbytes);
extern  int             uio_write(_fd_t fd, const void *buffer, size_t nbytes);
extern  long            uio_lseek(_fd_t fd, long offset, _whence_t whence);
extern  _err_t          uio_close(_fd_t fd);

#endif
