/* @(#)host.h   1.2 */

#ifndef HOST_H
#define HOST_H

#include <osek/uio.h>

extern  int_least8_t    host_open(const char *pathname, uint_least16_t flags);
extern  void            host_read(device_t dev, ioreq_t *request);
extern  ioreq_t *       host_read_abort(device_t dev);
extern  void            host_write(device_t dev, ioreq_t *request);
extern  ioreq_t *       host_write_abort(device_t dev);
extern  long            host_lseek(device_t dev, long offset, uint_least8_t whence);
extern  int_least8_t    host_close(device_t dev);

#endif
